/**
* \file: cmdline_parser.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Rexaline Xavier  /  RexalineInfancia.Xavier@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_UTIL_CMDLINE_PARSER_H
#define ALD_UTIL_CMDLINE_PARSER_H

#include "ald_types.h"

#define INIT_LEVEL_CMD_SHORT "-l"
#define INIT_LEVEL_CMD_LONG "--initlevel"

#define STATE_PATH_CMD_SHORT "-t"
#define STATE_PATH_CMD_LONG "--statepath"

#define SCRIPT_ROOT_CMD_SHORT "-r"
#define SCRIPT_ROOT_CMD_LONG "--rootdir"

#define SYSROOT_CMD_SHORT "-s"
#define SYSROOT_CMD_LONG "--sysroot"

#define SIGDB_KEY_CMD_SHORT "-d"
#define SIGDB_KEY_CMD_LONG "--sigdbpubkeypath"

#define SIGDB_PRIVKEY_CMD_SHORT "-p"
#define SIGDB_PRIVKEY_CMD_LONG "--sigdbprivkeypath"

#define PRIVKEY_DEST_CMD_SHORT "-k"
#define PRIVKEY_DEST_CMD_LONG "--privkeyspath"

#define SIG_DB_CMD_SHORT "-g"
#define SIG_DB_CMD_LONG "--sigdbpath"

#define LEVELNUM_CMD_SHORT "-n"
#define LEVELNUM_CMD_LONG "--levelnum"

#define LEVELPRIVKEY_CMD_SHORT "-i"
#define LEVELPRIVKEY_CMD_LONG "--levelprivkey"

#define SERIALNUM_CMD_SHORT "-a"
#define SERIALNUM_CMD_LONG "--serialnum"

#define ECUID_CMD_SHORT "-e"
#define ECUID_CMD_LONG "--ecuid"

#define CONFFILE_CMD_SHORT "-c"
#define CONFFILE_CMD_LONG "--conffile"

#define HELP_CMD_SHORT "-h"
#define HELP_CMD_LONG "--help"

extern const cfg_cmd_line_spec_t init_level_cmdline_spec;
extern const cfg_cmd_line_spec_t state_path_cmdline_spec;
extern const cfg_cmd_line_spec_t script_root_cmdline_spec;
extern const cfg_cmd_line_spec_t sysroot_cmdline_spec;
extern const cfg_cmd_line_spec_t priv_key_dest_cmdline_spec;
extern const cfg_cmd_line_spec_t sig_db_cmdline_spec;

extern const cfg_cmd_line_spec_t sigdb_key_cmdline_spec;
extern const cfg_cmd_line_spec_t sigdb_privkey_cmdline_spec;

extern const cfg_cmd_line_spec_t levelnum_cmdline_spec;
extern const cfg_cmd_line_spec_t levelprivkey_cmdline_spec;
extern const cfg_cmd_line_spec_t serialnum_cmdline_spec;
extern const cfg_cmd_line_spec_t ecuid_cmdline_spec;

extern const cfg_cmd_line_spec_t conffile_cmdline_spec;
extern const cfg_cmd_line_spec_t help_cmdline_spec;


error_code_t cmdline_parser_parse_cmd_line(cfg_item_t *const items[], size_t items_count,
			char *argv[], size_t argc);

#endif
